### DIRECTORIO DE TRABAJO ###
# Puedes encontrar su directorio de trabajo con la funcion getwd()
# Se mostrara en la consola la ruta del directorio que esta usando R
# Puede cambiar el directorio de trabajo usando la funcion setwd(), dando como argumento la ruta del directorio
# El directorio de trabajo debe estar donde se guardan este archivo de R y cualquier archivo de datos requerido 
# Por ejemplo setwd("C:/Users/Username/Documents")

getwd()
setwd(" ... ")

### PAQUETES ###
# Los paquetes solo necesitan instalarse una vez, usando install.packages()
# Los paquetes deben cargarse, usando library(), en cada sesión

library(tidyverse)
library(openxlsx)
library(network)
library(igraph)
library(intergraph)
library(GGally)
library(sna) 

### LEER LOS DATOS ###

aristas <- read.xlsx("Redes de semillas.xlsx", sheet="aristas")
nodos <- read.xlsx("Redes de semillas.xlsx", sheet="nodos")

### MANIPULAR LOS DATOS ###
# Combinar las etiquetas (labels) de los nodos con las aristas

aristas1 <- aristas %>%
              inner_join(
                select(nodos,"Id","from"="Label"), by=c("Source"="Id")
                ) %>%
              inner_join(
                select(nodos,"Id","to"="Label"), by=c("Target"="Id")
                )
              

# Eliminar los aristas que son bucles
aristas2 <- filter(aristas1, from!=to)

# Filtrar las estrategias
estlocal<-aristas2 %>%
          filter(Estrategia %in% c("Acuerdos","Pago en especie", "Compra y venta", "Herencia", "Intercambio", "Regalo", "Robo"))
 
### CREAR LA RED BASICA ###

net = network(dplyr::select(estlocal,"from","to"), directed = TRUE, multiple=TRUE)

### AGREGAR VARIABLES ADICIONALES ###
# Crear el dataframe de los nodos que coincida con la lista de las aristas de la red

nodos1 <- data.frame(Node = network.vertex.names(net)) %>%
            mutate(Node=as.character(Node)) %>%
            full_join(nodos,by=c("Node"="Label"))

# Incluir variables de los nodos usando %v%
# Incluir variables de los aristas usando %e%

net %v% "Actors" = as.character(nodos1$Actors)
net %e% "Estrategia" = as.character(estlocal$Estrategia)

net <- net %>%
        asIgraph()

### MEJORAR LA APARIENCIA DEL GRAFICO ####
# Este código se puede editar para cambiar la apariencia del gráfico

unique(V(net)$Actors)
color1 <- c("turquoise","purple","grey","limegreen","#660033")
color_Actors<- color1[as.numeric(as.factor(V(net)$Actors))]

unique(E(net)$Estrategia)
color2 <- c("black","turquoise","orange","limegreen","blue","brown","purple")
color_Estrategia <- color2[as.numeric(as.factor(E(net)$Estrategia))]


# Grafico

plot(net,
     main="Estrategia familiar",
     layout=layout.auto,             # Distribución de los nodos
     edge.arrow.size=0.1,             # Tamaño de la cabeza de la flecha
     edge.curved=0.7,                 # Curvatura de las aristas
     edge.color=color_Estrategia,    # Color de las aristas
     edge.width=0.8,                  # Ancho de las aristas
     vertex.color=color_Actors,      # color de los nodos
     vertex.frame.color=color_Actors,# color el contorno de los nodos
     vertex.size=5,                  # Tamaño del nodo
     vertex.shape="sphere",          # Forma del nodo
     vertex.label=NA                 #no mostrar etiquetas (NA)
)

legend("topleft",
       legend=levels(as.factor(V(net)$Actors)),
       col=color1,
       pt.bg=color1,
       pch=21,
       bty="n",
       title="ACTORES",
       title.col="black",
       title.adj=0.1,
       pt.cex= 1.4,
       cex=0.6,
       text.col=color1)

legend(x=-2.2, y =0.2,
       legend=levels(as.factor(E(net)$Estrategia)),
       lty=1,
       col=color2,
       bty="n",
       title="ESTRATEGIAS",
       title.col="black",
       title.adj=0.1,
       cex=0.6,
       text.col=color2)
